/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.block.HighBlock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommentManager
implements Serializable {
    static final long serialVersionUID = 6650271596113012551L;
    private int commentManagerSerializedDataVersion = 2;
    protected Hashtable fHashtable = new Hashtable();

    public CommentParameter getCommentParameter(Block block) {
        return this.getCommentParameter(this.getKey(block));
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.commentManagerSerializedDataVersion < 2) {
            this.commentManagerSerializedDataVersion = 2;
            this.removeLeadingZeroesInBlockNames();
        }
    }

    private void removeLeadingZeroesInBlockNames() {
        Hashtable newCommentHashtable = new Hashtable(this.fHashtable.size());
        Pattern p = Pattern.compile("(\\D*)(?:0*)(\\d*)(.*)");
        for (String blockName : this.fHashtable.keySet()) {
            Object commentParameter = this.fHashtable.get(blockName);
            Matcher m = p.matcher(blockName);
            m.matches();
            String blockNumberPrefix = m.group(1);
            String blockNumberWithoutLeadingZeroes = m.group(2);
            newCommentHashtable.put(blockNumberPrefix + blockNumberWithoutLeadingZeroes, commentParameter);
        }
        this.fHashtable = newCommentHashtable;
    }

    public CommentParameter addCommentParameter(Block block, CommentParameter commentParameter) {
        this.removeCommentListeners(block);
        return this.fHashtable.put(this.getKey(block), commentParameter);
    }

    private Object getKey(Block block) {
        String blockString = "";
        if (block instanceof HighBlock) {
            HighBlock cfr_ignored_0 = (HighBlock)block;
            blockString = block.getNumberPrefix() + HighBlock.getKeyNumber() + block.getNumberPostfix();
        } else {
            blockString = block.getNumberPrefix() + block.getNumber() + block.getNumberPostfix();
        }
        return blockString;
    }

    private CommentParameter getCommentParameter(Object key) {
        CommentParameter parameter = null;
        parameter = (CommentParameter)this.fHashtable.get(key);
        if (parameter == null) {
            CommentParameter commentParameter = new CommentParameter();
            this.fHashtable.put(key, commentParameter);
            return commentParameter;
        }
        return parameter;
    }

    public boolean containsCommentedForBlock(Block block) {
        return this.fHashtable.containsKey(this.getKey(block));
    }

    private void removeCommentListeners(Block block) {
        CommentParameter commentParameter = (CommentParameter)this.fHashtable.get(this.getKey(block));
        if (commentParameter == null) {
            return;
        }
        commentParameter.removeAllParameterSetListeners();
    }

    public void removeCommentParameter(Block block) {
        this.removeCommentListeners(block);
        this.fHashtable.remove(this.getKey(block));
    }

    public void print() {
        Enumeration keys = this.fHashtable.keys();
        Object key = null;
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            System.out.println(key + " = " + this.fHashtable.get(key));
        }
    }
}

